<?php
/**
 * Template part for displaying posts.
 *
 * @package Steve Maloney and the Wandering Kind
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php the_title( sprintf( '<h1 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h1>' ); ?>

		<?php if ( 'post' == get_post_type() ) : ?>
		<div class="entry-meta">
			<?php www_stevemaloneymusi_com_posted_on(); ?>
		</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->

	<?php echo get_the_post_thumbnail( $post_id, $size, $attr ); ?>

	<div class="entry-content">
		<?php
			/* translators: %s: Name of current post */
			the_content( sprintf(
				wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'www-stevemaloneymusi-com' ), array( 'span' => array( 'class' => array() ) ) ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) );
		?>

		
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php www_stevemaloneymusi_com_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
