<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Steve Maloney and the Wandering Kind
 */

get_header(); ?>
		

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

		<?php if ( have_posts() ) : ?>

			<?php /* Start the Loop */ ?>

		

			<?php while ( have_posts() ) : the_post(); ?>

				<?php

					/*
					 * Include the Post-Format-specific template for the content.
					 * If you want to override this in a child theme, then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */
					get_template_part( 'template-parts/content', get_post_format() );
				?>



			<?php endwhile; ?>

			<?php the_posts_navigation(); ?>

	

		<?php else : ?>

			<?php get_template_part( 'template-parts/content', 'none' ); ?>

		<?php endif; ?>



		</main><!-- #main -->


	</div><!-- #primary -->


	<div class="eventslist">

		<div class="eventheader"><h1>Upcoming Shows</h1></div>
		<div class="eventsbox">
		<?php $event = new WP_Query(array(
					'post_type' => 'event',
					'posts_per_page' => 20,
					'orderby' => 'date',
					'order' => 'ASC'
					)); ?>
				<?php while($event->have_posts()) : $event-> the_post(); ?>
		<div class="event">
			<div class="eventdate"><?php the_field('event_date'); ?></div>
			<div class="eventtitle"><?php the_field('event_title'); ?></div>
			<div class="eventdetails"><?php the_field('event_details'); ?></div>
		</div>
<?php endwhile; ?>
	</div>
	</div>

<?php get_sidebar(); ?>
<?php get_footer(); ?>
