<?php
/**
 * Jetpack Compatibility File
 * See: https://jetpack.me/
 *
 * @package Steve Maloney and the Wandering Kind
 */

/**
 * Add theme support for Infinite Scroll.
 * See: https://jetpack.me/support/infinite-scroll/
 */
function www_stevemaloneymusi_com_jetpack_setup() {
	add_theme_support( 'infinite-scroll', array(
		'container' => 'main',
		'render'    => 'www_stevemaloneymusi_com_infinite_scroll_render',
		'footer'    => 'page',
	) );
} // end function www_stevemaloneymusi_com_jetpack_setup
add_action( 'after_setup_theme', 'www_stevemaloneymusi_com_jetpack_setup' );

/**
 * Custom render function for Infinite Scroll.
 */
function www_stevemaloneymusi_com_infinite_scroll_render() {
	while ( have_posts() ) {
		the_post();
		get_template_part( 'template-parts/content', get_post_format() );
	}
} // end function www_stevemaloneymusi_com_infinite_scroll_render
