<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package Steve Maloney and the Wandering Kind
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<!-- Google Tag Manager -->
<noscript><iframe src="//www.googletagmanager.com/ns.html?id=GTM-MFB4FK"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'//www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-MFB4FK');</script>
<!-- End Google Tag Manager -->
<div id="page" class="hfeed site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'www-stevemaloneymusi-com' ); ?></a>

	<header id="masthead" class="site-header" role="banner">
		<div class="site-branding">
			<img src="http://www.stevemaloneymusic.com/wp-content/uploads/2015/06/steve-maloney-wandering-kind-window.jpeg" class="main-image">
			<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
			<div class="socialbox">
				<a href="https://instagram.com/steguyfriend/"><img src="http://www.stevemaloneymusic.com/wp-content/uploads/2015/06/steve-maloney-instagram.svg" alt="" class="socialimg"></a>
				<a href="https://www.youtube.com/user/stemusicfeed"><img src="http://www.stevemaloneymusic.com/wp-content/uploads/2015/06/steve-maloney-toutube.svg" alt="" class="socialimg"></a>
				<a href="https://twitter.com/stevenoise"><img src="http://www.stevemaloneymusic.com/wp-content/uploads/2015/06/steve-maloney-twitter.svg" alt="" class="socialimg"></a>
				<a href="https://www.facebook.com/wanderingkind"><img src="http://www.stevemaloneymusic.com/wp-content/uploads/2015/06/steve-maloney-facebook.svg" alt="" class="socialimg"></a>
				<a href="http://www.stevemaloneymusic.com/contact"><img src="http://www.stevemaloneymusic.com/wp-content/uploads/2015/06/steve-maloney-contact.svg" alt="" class="socialimg"></a>
			</div>
		</div><!-- .site-branding -->

		<nav id="site-navigation" class="main-navigation" role="navigation">
			<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><?php esc_html_e( 'Menu', 'www-stevemaloneymusi-com' ); ?></button>
			<?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_id' => 'primary-menu' ) ); ?>
		</nav><!-- #site-navigation -->
	</header><!-- #masthead -->

	<div id="content" class="site-content">
