<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Steve Maloney
 */

get_header(); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

			<?php  
if ( function_exists( 'soliloquy' ) ) { soliloquy( 'feature-slider', 'slug' ); }
?>

		<!-- <div class="featurephoto">
			<img src="http://localhost/steve-maloney/wp-content/uploads/2015/03/steve-maloney-and-the-wandering-tree1.jpg" alt="">
			<div class="featuretext">
				Steve Maloney and the Wandering Kind at ECMA 2015
			</div></div>  -->
		
		<div class="newssection">

		<div class="sectionheader">

			<h1>News</h1>
			</div>

		<?php if ( have_posts() ) : ?>

			<?php /* Start the Loop */ ?>
			<?php while ( have_posts() ) : the_post(); ?>

				<?php
					/* Include the Post-Format-specific template for the content.
					 * If you want to override this in a child theme, then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */
					get_template_part( 'content', get_post_format() );
				?>

			<?php endwhile; ?>

			<?php the_posts_navigation(); ?>

		<?php else : ?>

			<?php get_template_part( 'content', 'none' ); ?>

		<?php endif; ?>
</div>
		</main><!-- #main -->
	</div><!-- #primary -->

	<div class="eventslist">

		<div class="eventheader">UPCOMING SHOWS</div>

		<?php $event = new WP_Query(array(
					'post_type' => 'event',
					'posts_per_page' => 8,
					'orderby' => 'date',
					'order' => 'ASC'
					)); ?>
				<?php while($event->have_posts()) : $event-> the_post(); ?>
		<div class="event">
			<div class="eventdate"><?php the_field('event_date'); ?></div>
			<div class="eventtitle"><?php the_field('event_title'); ?></div>
			<div class="eventdetails"><?php the_field('event_details'); ?></div>
		</div>
<?php endwhile; ?>
	
	</div>

<?php get_sidebar(); ?>
<?php get_footer(); ?>
