<?php

/**

 * The header for our theme.

 *

 * Displays all of the <head> section and everything up till <div id="content">

 *

 * @package Steve Maloney

 */

?><!DOCTYPE html>

<html <?php language_attributes(); ?>>

<head>

<meta charset="<?php bloginfo( 'charset' ); ?>">

<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="profile" href="http://gmpg.org/xfn/11">

<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">



<?php wp_head(); ?>

</head>



<body <?php body_class(); ?>>

<div class="bgwrapper">

<div id="page" class="hfeed site">

	<a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'steve-maloney' ); ?></a>



	<header id="masthead" class="site-header" role="banner">

		<div class="site-branding">

			<div class="logo">

			<img src="http://www.stevemaloneymusic.com/wp-content/uploads/2015/04/stevemaloneylogo.png" alt=""><a href="http://www.stevemaloneymusic.com"></a></img>

			</div>

			<div class="itunesbuttonbox"><div class="itunesbutton"><!-- <img src="http://www.stevemaloneymusic.com/wp-content/uploads/2015/04/steve-maloney-and-the-wandering-kind-itunes1.svg" alt="Steve Maloney and the Wandering Kind iTunes" class="itunesimage"> --><a href="https://itunes.apple.com/ca/album/steve-maloney-wandering-kind/id841120656" class="ituneslink">Buy the album on iTunes</a></div></div><div class="socialbox">

			<div class="socialbutton"><a href="https://instagram.com/steguyfriend"><img src="http://www.stevemaloneymusic.com/wp-content/uploads/2015/04/steve-maloney-instagram.svg" alt="" class="socialimg"></a></div><div class="socialbutton"><a href="https://www.facebook.com/wanderingkind"><img src="http://www.stevemaloneymusic.com/wp-content/uploads/2015/04/steve-maloney-facebook3.svg" alt="" class="socialimg"></a></div><div class="socialbutton"><a href="https://www.youtube.com/user/stemusicfeed"><img src="http://www.stevemaloneymusic.com/wp-content/uploads/2015/04/steve-maloney-youtube.svg" alt="" class="socialimg"></a></div><div class="socialbutton"><a href="https://twitter.com/stevenoise"><img src="http://www.stevemaloneymusic.com/wp-content/uploads/2015/04/steve-maloney-twitter.svg" alt="" class="socialimg"></a></div>

			</div>

			

		<!-- .site-branding -->



		<nav id="site-navigation" class="main-navigation aligncenter" role="navigation">

			<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><?php _e( 'Primary Menu', 'steve-maloney' ); ?></button>

			<?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_id' => 'primary-menu' ) ); ?>

		</nav><!-- #site-navigation -->

	</header><!-- #masthead -->



	<div id="content" class="site-content">

